const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
    saveServerUrl: (url) => ipcRenderer.send('save-server-url', url),
    getInitialData: () => ipcRenderer.invoke('get-initial-data'),
    getSettings: () => ipcRenderer.invoke('get-settings'),
    getLobbyList: () => ipcRenderer.invoke('get-lobby-list'),
    manageSaveState: (options) => ipcRenderer.invoke('manage-save-state', options),
    getLocaleData: (lang) => ipcRenderer.invoke('get-locale-data', lang),
    getRelayConfig: () => ipcRenderer.invoke('get-relay-config'),

    saveAppSettings: (settings) => ipcRenderer.send('save-app-settings', settings),
    saveAllSettings: (settings) => ipcRenderer.send('save-all-settings', settings),
    saveSettingsOnExit: (settings) => ipcRenderer.send('save-settings-on-exit', settings),
    setRelayConfig: (config) => ipcRenderer.send('set-relay-config', config),
    relaunchApp: () => ipcRenderer.send('relaunch-app'),
    launchGame: (options) => ipcRenderer.send('launch-game', options),
    saveGame: (gamePath) => ipcRenderer.send('save-game', gamePath),
    downloadCollection: () => ipcRenderer.send('download-collection'),
    netplayHost: (options) => ipcRenderer.send('netplay-host', options),
    joinNetplayGame: (options) => ipcRenderer.send('join-netplay-game', options),
    setFullscreen: (isFullscreen) => ipcRenderer.send('set-fullscreen', isFullscreen),
    exitApp: () => ipcRenderer.send('exit-app'),
    suspendPc: () => ipcRenderer.send('suspend-pc'),
    powerOffPc: () => ipcRenderer.send('power-off-pc'),
    cancelEmuProcess: () => ipcRenderer.send('cancel-emu-process'),
    openExternalLink: (url) => ipcRenderer.send('open-external-link', url),

    onEmuProgress: (callback) => ipcRenderer.on('emu-progress', (_event, value) => callback(value)),
    onEmuExit: (callback) => ipcRenderer.on('emu-exit', (_event, value) => callback(value)),
});